/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Potion
**
** DESCRIPTION:	Applies/removes potion affects to/from villagers
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef POTION_H
#define POTION_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "../Villagers/VillagerAttachmentInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EPotion
{
	ePotion_None = -1,

	ePotion_BitterBeverage = 0,
	ePotion_Bubbles,
	ePotion_Burn,
	ePotion_Comprehension,
	ePotion_Concentration,
	ePotion_CureDisease,
	ePotion_Exercise,
	ePotion_Exhuberant,
	ePotion_Faint,
	ePotion_GreaterHealing,
	ePotion_Happy,
	ePotion_HighJump,
	ePotion_Horny,
	ePotion_MakeCold,
	ePotion_MakeHot,
	ePotion_MakeHungry,
	ePotion_MakeItchy,
	ePotion_MildFertility,
	ePotion_Hiccups,
	ePotion_MildHealing,
	ePotion_MildPoison,
	ePotion_Noxious,
	ePotion_Paralyze,
	ePotion_Potty,
	ePotion_Running,
	ePotion_Sad,
	ePotion_SharkCharmer,
	ePotion_SharkRepellant,
	ePotion_Sleep,
	ePotion_Spirituality,
	ePotion_StrongFertility,
	ePotion_StrongPoison,
	ePotion_SweetBeverage,
	ePotion_Teleport,
	ePotion_Tired,
	ePotion_Trance,
	ePotion_GarlicBreath,
	ePotion_BubbleBreath,
	ePotion_Crazy,
	ePotion_Blind,
	ePotion_KidsPotion,

	ePotion_NumberOf,
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CPotion : public IVillagerAttachment
{
private:

	//class data
	static int	sm_iDifficultyLevel[ePotion_NumberOf];

	//class methods
	//setup
	public:		CPotion(void);

	// process
	public:		void Attach(CVillager &Villager, const int iRef, int &iTime);
	public:		void Remove(CVillager &Villager, const int iRef);
	public:		void Update(CVillager &Villager, const int iRef, const unsigned int uiElapsedTime);

	// access
	public:		const int DifficultyLevel(const EPotion ePotion) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CPotion		Potion;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/